<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Information needed to pay using BLIK.
 */
class BlikPaymentRequest implements \JsonSerializable
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $countryCode;

    /**
     * @var string|null
     */
    private $email;

    /**
     * @var BlikExperienceContext|null
     */
    private $experienceContext;

    /**
     * @var BlikLevel0PaymentObject|null
     */
    private $level0;

    /**
     * @var BlikOneClickPaymentRequest|null
     */
    private $oneClick;

    /**
     * @param string $name
     * @param string $countryCode
     */
    public function __construct(string $name, string $countryCode)
    {
        $this->name = $name;
        $this->countryCode = $countryCode;
    }

    /**
     * Returns Name.
     * The full name representation like Mr J Smith.
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The full name representation like Mr J Smith.
     *
     * @required
     * @maps name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Country Code.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the country
     * or region. Note: The country code for Great Britain is GB and not UK as used in the top-level domain
     * names for that country. Use the `C2` country code for China worldwide for comparable uncontrolled
     * price (CUP) method, bank card, and cross-border transactions.
     */
    public function getCountryCode(): string
    {
        return $this->countryCode;
    }

    /**
     * Sets Country Code.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the country
     * or region. Note: The country code for Great Britain is GB and not UK as used in the top-level domain
     * names for that country. Use the `C2` country code for China worldwide for comparable uncontrolled
     * price (CUP) method, bank card, and cross-border transactions.
     *
     * @required
     * @maps country_code
     */
    public function setCountryCode(string $countryCode): void
    {
        $this->countryCode = $countryCode;
    }

    /**
     * Returns Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * Sets Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     *
     * @maps email
     */
    public function setEmail(?string $email): void
    {
        $this->email = $email;
    }

    /**
     * Returns Experience Context.
     * Customizes the payer experience during the approval process for the BLIK payment.
     */
    public function getExperienceContext(): ?BlikExperienceContext
    {
        return $this->experienceContext;
    }

    /**
     * Sets Experience Context.
     * Customizes the payer experience during the approval process for the BLIK payment.
     *
     * @maps experience_context
     */
    public function setExperienceContext(?BlikExperienceContext $experienceContext): void
    {
        $this->experienceContext = $experienceContext;
    }

    /**
     * Returns Level 0.
     * Information used to pay using BLIK level_0 flow.
     */
    public function getLevel0(): ?BlikLevel0PaymentObject
    {
        return $this->level0;
    }

    /**
     * Sets Level 0.
     * Information used to pay using BLIK level_0 flow.
     *
     * @maps level_0
     */
    public function setLevel0(?BlikLevel0PaymentObject $level0): void
    {
        $this->level0 = $level0;
    }

    /**
     * Returns One Click.
     * Information used to pay using BLIK one-click flow.
     */
    public function getOneClick(): ?BlikOneClickPaymentRequest
    {
        return $this->oneClick;
    }

    /**
     * Sets One Click.
     * Information used to pay using BLIK one-click flow.
     *
     * @maps one_click
     */
    public function setOneClick(?BlikOneClickPaymentRequest $oneClick): void
    {
        $this->oneClick = $oneClick;
    }

    /**
     * Converts the BlikPaymentRequest object to a human-readable string representation.
     *
     * @return string The string representation of the BlikPaymentRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'BlikPaymentRequest',
            [
                'name' => $this->name,
                'countryCode' => $this->countryCode,
                'email' => $this->email,
                'experienceContext' => $this->experienceContext,
                'level0' => $this->level0,
                'oneClick' => $this->oneClick
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['name']                   = $this->name;
        $json['country_code']           = $this->countryCode;
        if (isset($this->email)) {
            $json['email']              = $this->email;
        }
        if (isset($this->experienceContext)) {
            $json['experience_context'] = $this->experienceContext;
        }
        if (isset($this->level0)) {
            $json['level_0']            = $this->level0;
        }
        if (isset($this->oneClick)) {
            $json['one_click']          = $this->oneClick;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
